<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sales extends Model 
{

    protected $table = 'sales';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ticket_id', 'buyer_id', 'seller_id', 'date', 'quantity', 'total_price', 'price_actual', 'commission_amount', 'payment_id', 'transaction_id', 'payment_status', 'seller_status', 'buyer_status');

    public function getTicket()
    {
        return $this->belongsTo('Tickets', 'ticket_id');
    }

    public function getBuyerData()
    {
        return $this->belongsTo('User', 'buyer_id');
    }

    public function getSellerData()
    {
        return $this->belongsTo('User', 'seller_id');
    }

    public function getBuyerStatus()
    {
        return $this->belongsTo('Status', 'buyer_status');
    }

    public function getSellerStatus()
    {
        return $this->belongsTo('Status', 'seller_status');
    }

    public function getPayout()
    {
        return $this->hasOne('Payouts', 'sale_id');
    }

}